//Dustin Soodak

//Behavior 049: use gyro to sense wheel going off table
//Note: by the time it detects the tip, the wheel is already all the way off of the table.
//

#include "MiscHardware.h"
#include "Navigation.h"
//#include <math.h>
int i=0;
#define READINGS 100
int data[READINGS][3];
int gyroraw[3];
int accelraw[3];
uint32_t microinit;
void setup(){
  HardwareBegin();
  //while(!ButtonPressed());
  //delay(1000);
  //ExploreExample(150, 300, 500);
  
  Serial.println("enter detection level:");
  while(!Serial.available());
  GyroEdgeDetectionLevel=Serial.parseInt();
  Serial.print("\r\nDet Level: ");
  Serial.println(GyroEdgeDetectionLevel,DEC);
}
int accelx,accely,accelz,dir;
int gyrox,gyroy;
int32_t gyrototal=0;
int32_t gyroaverage=0;
char triggered=0;
void loop(){
  SwitchPixelsToButton();
  while(!ButtonPressed()); 
  while(ButtonPressed());
  delay(10);
  SwitchButtonToPixels();
  SetPixelRGB(4,50,0,0);RefreshPixels();  
  delay(500);
  SwitchButtonToPixels();
  SetPixelRGB(4,0,0,0);RefreshPixels();
  SwitchSerialToMotors();
  gyroaverage=0;
  gyrototal=0;
  Motors(100,100);
  i=0;
  microinit=micros();
  triggered=0;
  NavigationBegin();//initializes I2C and finds GyroZeroes[]
  while(i<READINGS){
    if(GyroBufferSize()){      
      GyroGetAxes(gyroraw);
      AccelGetAxes(accelraw);
      if(i<READINGS){
        data[i][0]=(micros()-microinit)/100;
        data[i][1]=gyroraw[1]-GyroZeroes[1];//y axis zeroed
        gyrototal+=data[i][1];
        gyroaverage+=(gyrototal-gyroaverage)/10;
        data[i][2]=gyroaverage/380;//accelraw[2]-AccelZeroes[2];//z-axis zeroed
        if((gyroaverage)/380>GyroEdgeDetectionLevel && !triggered){
          Motors(0,-200);
          SetPixelRGB(1,50,0,0);RefreshPixels();
          data[i][2]=999;
          triggered=1;
        }
        if((gyroaverage)/380<-GyroEdgeDetectionLevel && !triggered){
          Motors(-200,0);
          SetPixelRGB(1,0,50,0);RefreshPixels();
          data[i][2]=-999;
          triggered=1;
        }
        i++;
      }
      if(AccelBufferSize()>1)//to keep buffers in sync (gyro goes at 380hz while accel goes at 400hz)
        AccelGetAxes(accelraw);
    }      
  }
  Motors(0,0);
  SetAllPixelsRGB(0,0,0);
  //
  SwitchPixelsToButton();
  while(!ButtonPressed());
  SwitchMotorsToSerial();
  Serial.println("\r\n.1ms\tGyroYRawZeroed\tAccelZRawZeroed");
  for(i=0;i<READINGS;i++){
      Serial.print(data[i][0]);
      Serial.print("\t");
      Serial.print(data[i][1]);
      Serial.print("\t");
      Serial.println(data[i][2]);
  }
  while(ButtonPressed());
  delay(10);
  //
  /*
  while(!ButtonPressed());
  while(ButtonPressed());
  delay(500);
  NavigationBegin();   
  RestartTimer();
  while(!ButtonPressed()){
    SimpleNavigation();
    accelx=GetAccelerationX();
    accely=GetAccelerationYUnZeroed();
    accelz=GetAccelerationZ();
    gyrox=GetDegreesPerSecondX();
    gyroy=GetDegreesPerSecondY();
    dir=90-atan2(accely,accelx)*180/3.14159;
    if(GetTime()>200 || GyroEdgeDetected){
      Serial.print(accelx,DEC);
      Serial.print("\t");
      Serial.print(accely,DEC);
      Serial.print("\t");
      Serial.print(accelz,DEC);
      Serial.print("\tgx ");
      Serial.print(gyrox,DEC);
      Serial.print("\tgy ");
      Serial.print(gyroy,DEC);
      Serial.print("\tgz ");
      Serial.print(GetDegreesPerSecondZ(),DEC);
      Serial.print("\tyRaw ");
      Serial.print(GyroVelocity[1],DEC);
      Serial.print("\tedge ");
      Serial.print(GyroEdgeDetected,BIN);
      
      GyroEdgeDetected=0;
      Serial.println("");
      RestartTimer(); 
    }
  }//end while(!ButtonPressed())
  
  */
}//end loop()




